MenuOptions = copy_table(BaseView)
MenuOptions.definition = "menu_options"


function MenuOptions:init()
    BaseView.init(self)
    self.shortcuts.slider_sounds:set_level(game_settings.sound_volume)
    self.shortcuts.slider_music:set_level(game_settings.music_volume)
    self.shortcuts.version:set_text(string.format(str.options_version_info, product_version))
    self:refresh_ui(gfx_full_screen())
    self.sound_fade = 0
end


function MenuOptions:back_button()
    game_settings:save()
    fw:change_view(MainMenu, nil, "blend")
end


function MenuOptions:full_screen_button()
    if gfx_full_screen() then
        gfx_full_screen(false)
        game_settings.full_screen = false
        self:refresh_ui(false)
    else
        gfx_full_screen(true)
        game_settings.full_screen = true
        self:refresh_ui(true)
    end
end


function MenuOptions:sound_volume_change(obj)
    game_settings.sound_volume = obj:get_level()
    snd_sound_volume(game_settings.sound_volume * 100)
    if self.sound_fade <= 0 then
        snd_play_sound("button_click")
        self.sound_fade = 0.5
    end
end


function MenuOptions:music_volume_change(obj)
    game_settings.music_volume = obj:get_level()
    snd_music_volume(game_settings.music_volume * 100)
end


function MenuOptions:refresh_ui(full_screen)
    if full_screen then
        self.shortcuts.full_screen_info:set_text(str.options_switch_to_window)
        self.shortcuts.full_screen_button:set_text(str.button_window)
    else
        self.shortcuts.full_screen_info:set_text(str.options_switch_to_full_screen)
        self.shortcuts.full_screen_button:set_text(str.button_full_screen)
    end
end


function MenuOptions:update(dt)
    BaseView.update(self,dt)
    self.sound_fade = self.sound_fade - dt
end


function MenuOptions:credits_button()
    game_settings:save()
    fw:change_view(MenuCredits, nil, "blend")
end


function MenuOptions:support_button()
    game_settings:save()
    fw:change_view(MenuSupport, nil, "blend")
end
